/*******************************************************************************
+
+	cluster_kmeans.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
+	$Id: cluster_kmeans.cc,v 1.5 2000/05/26 03:10:38 kev Exp $
+
*******************************************************************************/

#include "cluster_kmeans.hh"

#include "cluster_random.hh"


static const char *rcsid = "$Id: cluster_kmeans.cc,v 1.5 2000/05/26 03:10:38 kev Exp $";
static const char *rcsrevision = "$Revision: 1.5 $";


static void debugPrintClusters() {
	int i;
	int clustnum = 0;
	point p;

	for (i = clusters.low(); i <= clusters.high(); i++) {
		Cluster &c = clusters[i];
		list<point> &pts = c.getList();
		(*debug) << c.rep << endl;
		forall(p, pts) {
			(*debug) << clustnum << " " << p << " " << annotation.access(p) << endl;
		}
		clustnum++;
		(*debug) << endl;
	}
}


static point findClusterRepresentative(Cluster &c)
{
	//assert(c.getList().length() > 0);
	if (c.getList().length() <= 0) {
		// Unchanged.
		return c.rep;
	} else {
		return c.meanPoint();
	}
}


static Cluster &findClosestRepresentative(point p)
{
	int i;

	//assert(clusters.size() > 0);

	int closest = 0;
	double d = p.sqr_dist(clusters[closest].rep);
	for (i = clusters.low(); i <= clusters.high(); i++) {
		Cluster &c = clusters[i];
		double d2 = p.sqr_dist(c.rep);
		if (d2 < d) {
			d = d2;
			closest = i;
		}
	}

	return clusters[closest];
}


void cluster_kmeans(int k) {
	int i;
	point p;
	list<point> points;
	array<point> oldReps;


	// Get an initial (random) clustering.
	cluster_random(k);


	while (true) {
		//debugPrintClusters();


		// Find the new representative for each cluster.
		for (i = clusters.low(); i <= clusters.high(); i++) {
			Cluster &c = clusters[i];
			//(*debug) << c.rep << " ";
			c.rep = findClusterRepresentative(c);
			//(*debug) << c.rep << endl;
		}


		// If the representatives found are the same as last time,
		// we're outta here.
		bool same = false;
		if (oldReps.size() > 0) {
			same = true;
			for(i = clusters.low(); i <= clusters.high(); i++) {
				if (clusters[i].rep != oldReps[i]) {
					same = false;
					break;
				}
			}
		}
		if (same) {
			break;
		} else {
			oldReps.resize(clusters.low(), clusters.high());
			for(i = clusters.low(); i <= clusters.high(); i++) {
				oldReps[i] = clusters[i].rep;
			}
		}


		// Clear the contents of each cluster in preparation for the new clustering.
		for (i = clusters.low(); i <= clusters.high(); i++) {
			Cluster &c = clusters[i];
			c.getList().clear();
		}


		// Now recompute the clusterings based on these cluster representatives.
		points = T.points();
		forall(p, points) {
			Cluster &c = findClosestRepresentative(p);
			//list<point> &L = c.getList();
			//(*debug) << "cluster length: before: " << L.length();
			c.append(p);
			//(*debug) << " after: " << L.length() << endl;
		}

	}

}


